package com.likewind.myapplication

import android.Manifest
import android.annotation.SuppressLint
import android.app.Activity
import android.app.AlertDialog
import android.app.DownloadManager
import android.content.*
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.graphics.Bitmap
import android.net.Uri
import android.os.*
import androidx.appcompat.app.AppCompatActivity
import android.view.ContextMenu
import android.view.MenuItem
import android.view.MotionEvent
import android.view.View
import android.webkit.*
import android.widget.ProgressBar
import android.widget.Toast
import androidx.annotation.RequiresApi
import androidx.core.app.ActivityCompat
import kotlin.random.Random
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.concurrent.TimeUnit
import android.text.Layout
import android.text.Spannable
import android.text.SpannableString
import android.text.style.AlignmentSpan
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.google.firebase.messaging.FirebaseMessaging
import java.io.File
import java.io.FileOutputStream

class FileCreationHelper {

    fun createTextFile(context: Context, fileName: String, logMessage: String) {
        // Get the directory where logs are saved in internal storage
        val logsDir = context.getExternalFilesDir(null)

        // Check if the directory exists, if not, create it
        logsDir?.mkdirs()

        // Create a File object for the text file
        val file = File(logsDir, fileName)

        try {
            // Create a FileOutputStream to write to the file
            val fileOutputStream = FileOutputStream(file, true) // Use 'true' to append content

            // Get the current timestamp
            val timeStamp = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(Date())

            // Format the log message with timestamp
            val formattedLog = "$timeStamp: $logMessage\n"

            // Write the formatted log to the file
            fileOutputStream.write(formattedLog.toByteArray())

            // Close the FileOutputStream
            fileOutputStream.close()

        } catch (e: Exception) {
            e.printStackTrace()
            Toast.makeText(context, "Failed to save log message", Toast.LENGTH_SHORT).show()
        }
    }
}

class MainActivity : AppCompatActivity() {

    lateinit var webView: WebView
    lateinit var context: Context
    lateinit var activity: Activity
    lateinit var downloadListener: DownloadListener
    var writeAccess = false

    /** Permission Request Code */
    private val PERMISSION_REQUEST_CODE = 1234

    private val PREFS_NAME = "MyAppPrefs"
    private val FIRST_RUN_KEY = "firstRun"


    /** Sample Page from which we will download the file */
    //private val downloadPage = "https://demo.vl.fyi/PHP/DownloadFile/index.php"
    //private val downloadPage = "https://likewind.ml/doku.php?id=journey:%EC%97%AC%ED%96%89"
    private var downloadPage = "https://likewind.cloud/doku.php?id=journey:%EC%97%AC%ED%96%89"

    var backPressedTime: Long = 0

    // Set the date of May 4, 2015
    val startDate = getDateFromString("2015-05-04")

    // Get the current date
    val currentDate = Date()

    // Calculate the difference in days
    val daysDifference = calculateDaysDifference(startDate, currentDate)

    // ProgressBar
    companion object {
        lateinit var progressBar: ProgressBar
    }

    // Refresh
    /**
    private lateinit var swipeRefreshLayout: SwipeRefreshLayout
*/

    // Count number of touch screen
    private var tapCount = 0
    private val handler = Handler()
    private val tapDelay = 1000L // 1 second


    private val urlReceiver = object : BroadcastReceiver() {

        val fileCreationHelper = FileCreationHelper()

        override fun onReceive(context: Context?, intent: Intent?) {

            //fileCreationHelper.createTextFile(this@MainActivity, "log.txt", "fffffffffffff")

            intent?.let {
                if (it.action == MyFirebaseMessagingService.ACTION_OPEN_URL) {
                    val url = it.getStringExtra(MyFirebaseMessagingService.EXTRA_URL)
                    //fileCreationHelper.createTextFile(this@MainActivity, "log.txt", "gggggggggggggggggggggg")
                    openUrlInWebView(url)
                }
            }
        }
    }



    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        val fileCreationHelper = FileCreationHelper()

        // Example log message
        val logMessage = "This is a log message."

        // Specify the desired log file name (e.g., "log.txt")
        val logFileName = "log.txt"

        // Save the log message to the log file
        fileCreationHelper.createTextFile(this, logFileName, logMessage)
        //fileCreationHelper.createTextFile(this, logFileName, "1.wjkim loggs $logMessage")

        // Display a Toast with the location of the saved log file
        val logFilePath = File(this.getExternalFilesDir(null), logFileName).absolutePath

        // Initialize Firebase
        FirebaseMessaging.getInstance().subscribeToTopic("likewind_wjkim")


        val locale = resources.configuration.locales[0]
        val daysDifferenceKor = getNumKorString(daysDifference)


        // Check if it's the first run
        if (isFirstRun()) {
            // Code to run only on the first launch
            //showToast("First time running the app!")

            downloadPage = when (locale.language) {
                "es" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%8A%A4%ED%8E%98%EC%9D%B8%EC%96%B4"
                "ko" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95"
                "en" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%98%81%EC%96%B4"
                else -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%98%81%EC%96%B4"
            }

            //downloadPage = "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95"
            // Mark the first run as done
            markFirstRunDone()
        } else {
            // Code to run on subsequent launches
            //showToast("Welcome back!")
            //private val downloadPage = "https://likewind.cloud/doku.php?id=journey:%EC%97%AC%ED%96%89"
        }

        /** Application Context and Main Activity */
        context = applicationContext
        activity = this

        /** Initialize main layout and web view */
        webView = findViewById(R.id.webView)

        /** Initialize progressBar view */
        progressBar = findViewById(R.id.progressBar)

        /** Initialize swipeRefresh view */
        /**
        swipeRefreshLayout = findViewById(R.id.swipeRefreshLayout)
*/

        /** Check permission to write in external storage */
        checkWriteAccess()
        /** Create a Download Listener */
        createDownloadListener()
        /** Display Toast Message When Download Complete */
        onDownloadComplete()
        /** Configure Web View */
        configureWebView()

        //Toast.makeText(this, getRandomQuote(), Toast.LENGTH_SHORT).show()
        // Display the result using Toast

        //val locale = resources.configuration.locales[0]
        //val daysDifferenceKor = getNumKorString(daysDifference)

        val toastMessage = when (locale.language) {
            "es" -> "$daysDifference Días en la carretera"
           // "ko" -> "길 위에서 $daysDifferenceKor 일"
            "ko" -> "길 위에서 $daysDifference 일"
            "en" -> "$daysDifference Days on the road"
            else -> "$daysDifference Days on the road"
        }

        Toast.makeText(this, toastMessage, Toast.LENGTH_SHORT).show()

/**
        val daysDifferenceKor = getNumKorString(daysDifference)
        val toastMessage = "길 위에서 $daysDifferenceKor 일"
        //val toastMessage = "$daysDifference days on the road"
        Toast.makeText(this, toastMessage, Toast.LENGTH_SHORT).show()
   */

        registerForContextMenu(webView)

        /**
        // Set a long click listener to show the context menu
        webView.setOnLongClickListener {
            openContextMenu(it)
            true
        }
        */

        /**
        // Set up tap listener
        webView.setOnTouchListener { _, event ->
            if (event.action == MotionEvent.ACTION_DOWN) {
                tapCount++
                handler.removeCallbacksAndMessages(null) // Remove previous callbacks
                handler.postDelayed({ checkTapCount() }, tapDelay)
            }
            false
        }
        */

        // Register the local broadcast receiver
        LocalBroadcastManager.getInstance(this).registerReceiver(urlReceiver, IntentFilter(MyFirebaseMessagingService.ACTION_OPEN_URL))

        // Check if the activity was started due to a notification click
        val urlFromNotification = intent.getStringExtra(MyFirebaseMessagingService.EXTRA_URL)

        //fileCreationHelper.createTextFile(this, "log.txt", "0000000000000000")

        if (!urlFromNotification.isNullOrBlank()) {
            openUrlInWebView(urlFromNotification)
            //fileCreationHelper.createTextFile(this, "log.txt", "11111111111111111111")
        } else {
            //fileCreationHelper.createTextFile(this, "log.txt", "22222222222222")
            // Load the initial URL only if it's not started from a notification click
            //webView.loadUrl("https://www.yahoo.com")
        }


    }


    private fun openUrlInWebView(url: String?) {
        //val fileCreationHelper = FileCreationHelper()

        url?.let {
            //showToast(it)

            //fileCreationHelper.createTextFile(this, "log.txt", "3333333333333")

            // Use Handler to run on the main (UI) thread
            Handler(Looper.getMainLooper()).post {
                //fileCreationHelper.createTextFile(this, "log.txt", "444444444444")

                // Load the URL in the WebView
                webView.loadUrl(it)
            }
        }
    }

    override fun onDestroy() {
        val fileCreationHelper = FileCreationHelper()

        //fileCreationHelper.createTextFile(this, "log.txt", "555555555555")
        // Unregister the local broadcast receiver
        LocalBroadcastManager.getInstance(this).unregisterReceiver(urlReceiver)
        super.onDestroy()
    }

    /**
    private fun showToast(message: String) {
        // Display a Toast with the received message data
        // You can modify this to display the data in your desired way
        // For simplicity, using a Toast here
        // Make sure to run this on the main thread

        // Use Handler to run on the main (UI) thread
        Toast.makeText(applicationContext, message, Toast.LENGTH_LONG).show()
    }
*/

    override fun onNewIntent(intent: Intent?) {

        val fileCreationHelper = FileCreationHelper()

        super.onNewIntent(intent)

        // Check if the new intent contains a URL
        val urlFromIntent = intent?.getStringExtra(MyFirebaseMessagingService.EXTRA_URL)
        if (!urlFromIntent.isNullOrBlank()) {
            openUrlInWebView(urlFromIntent)
            fileCreationHelper.createTextFile(this, "log.txt", "New Intent - URL: $urlFromIntent")
        }
    }

    /**
    private fun checkTapCount() {
        if (tapCount == 7) {
            /**
            //showHelloPopup()
            //openContextMenu(webView)
            //webView.loadData("<html><body><h1>남기는말</h1><p><h2>즐거웠습니다</h2><p><h3>길 위에서</h3><p><h4>알게되었습니다</h4><p><h5>감사합니다</h5></body></html>", "text/html", null)
            val htmlData = """
                            |<html>
                            |<head>
                            |<style>
                            |   @font-face {
                            |       font-family: 'RIDIBatang';
                            |       src: url('file:///android_asset/RIDIBatang.otf');
                            |   }
                            |   body {
                            |       font-family: 'RIDIBatang';
                            |   }
                            |</style>
                            |</head>
                            |<body>
                            |   <h1>남기는말</h1><p><h2>즐거웠습니다</h2><p><h3>길 위에서</h3><p><h4>알게되었습니다</h4><p><h5>감사합니다</h5><p>그냥 감사합니다<p>likewind
                            |</body>
                            |</html>
                        """.trimMargin()
            webView.loadDataWithBaseURL(null, htmlData, "text/html", "UTF-8", null)
            */
            webView.loadUrl("https://likewind.cloud/doku.php?id=etc:%EB%82%A8%EA%B8%B0%EB%8A%94_%EA%B8%80")

        }
        tapCount = 0 // Reset tap count
    }
    */

    /**
    private fun showHelloPopup() {
        Toast.makeText(this, "Hidden Menu", Toast.LENGTH_SHORT).show()
    }
*/

    private fun isFirstRun(): Boolean {
        val prefs: SharedPreferences = getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
        // Default value is true if the key doesn't exist
        return prefs.getBoolean(FIRST_RUN_KEY, true)
    }

    private fun markFirstRunDone() {
        val prefs: SharedPreferences = getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
        val editor: SharedPreferences.Editor = prefs.edit()
        editor.putBoolean(FIRST_RUN_KEY, false)
        editor.apply()
    }

    override fun onBackPressed() {
        if (webView.canGoBack()) {
            webView.goBack()
        } else {
            if(backPressedTime + 3000 > System.currentTimeMillis()) {
                super.onBackPressed()
            }else{
                Toast.makeText(applicationContext, "한번 더 뒤로가기 버튼을 누르면 종료됩니다", Toast.LENGTH_SHORT).show()
            }
            backPressedTime = System.currentTimeMillis()
        }
    }


    override fun onCreateContextMenu(
        menu: ContextMenu?,
        v: View?,
        menuInfo: ContextMenu.ContextMenuInfo?
    ) {
        super.onCreateContextMenu(menu, v, menuInfo)

        // Get the current language of the phone
        val currentLanguage = getCurrentLanguage()

        // Set the locale for the context menu
        val config = Configuration(resources.configuration)
        config.setLocale(Locale(currentLanguage))
        val localizedContext = createConfigurationContext(config)

        // Create a SpannableString for "Option A" with center alignment
        val optionALabel = getString(R.string.option_a)
        val optionASpannable = SpannableString(optionALabel)
        optionASpannable.setSpan(
            AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER),
            0,
            optionASpannable.length,
            Spannable.SPAN_INCLUSIVE_EXCLUSIVE
        )

        // Add the centered "Option A" to the context menu with a unique identifier (1)
        val optionAMenuItem = menu?.add(0, 1, 0, optionASpannable) ?: return
        setMenuItemTitleCentered(optionAMenuItem)

        // Create a SpannableString for "Option B" with center alignment
        val optionBLabel = getString(R.string.option_b)
        val optionBSpannable = SpannableString(optionBLabel)
        optionBSpannable.setSpan(
            AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER),
            0,
            optionBSpannable.length,
            Spannable.SPAN_INCLUSIVE_EXCLUSIVE
        )

        // Add the centered "Option B" to the context menu with a unique identifier (2)
        val optionBMenuItem = menu.add(0, 2, 0, optionBSpannable) ?: return
        setMenuItemTitleCentered(optionBMenuItem)

        // Create a SpannableString for "Option C" with center alignment
        val optionCLabel = getString(R.string.option_c)
        val optionCSpannable = SpannableString(optionCLabel)
        optionCSpannable.setSpan(
            AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER),
            0,
            optionCSpannable.length,
            Spannable.SPAN_INCLUSIVE_EXCLUSIVE
        )

        // Add the centered "Option C" to the context menu with a unique identifier (3)
        val optionCMenuItem = menu.add(0, 3, 0, optionCSpannable) ?: return
        setMenuItemTitleCentered(optionCMenuItem)


        // Create a SpannableString for "Option D" with center alignment
        val optionDLabel = getString(R.string.option_d)
        val optionDSpannable = SpannableString(optionDLabel)
        optionDSpannable.setSpan(
            AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER),
            0,
            optionDSpannable.length,
            Spannable.SPAN_INCLUSIVE_EXCLUSIVE
        )

        // Add the centered "Option D" to the context menu with a unique identifier (3)
        val optionDMenuItem = menu.add(0, 4, 0, optionDSpannable) ?: return
        setMenuItemTitleCentered(optionDMenuItem)


    }

    private fun getCurrentLanguage(): String {
        // Get the current language of the phone
        return resources.configuration.locale.language
    }


    // Function to set the title of a MenuItem as centered
    private fun setMenuItemTitleCentered(menuItem: MenuItem) {
        val layout = menuItem.title as? Spannable
        layout?.let {
            val spans = it.getSpans(0, it.length, AlignmentSpan::class.java)
            if (spans != null && spans.isNotEmpty()) {
                for (span in spans) {
                    it.removeSpan(span)
                }
            }
            it.setSpan(
                AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER),
                0,
                it.length,
                Spannable.SPAN_INCLUSIVE_EXCLUSIVE
            )
        }
    }

    override fun onContextItemSelected(item: MenuItem): Boolean {
        var helpPage = "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%98%81%EC%96%B4"

        val helplocale = resources.configuration.locales[0]

        when (item.itemId) {
            1 -> {
                //showToast("You selected Option A")
                webView.loadUrl("https://likewind.cloud/doku.php?id=journey:%EC%97%AC%ED%96%89")
                return true
            }
            2 -> {
                //showToast("You selected Option B")
                webView.loadUrl("https://likewind.cloud/doku.php?id=journey:bicycle_route")
                return true
            }
            3 -> {
                //showToast("You selected Option C")

                helpPage = when (helplocale.language) {
                    "es" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%8A%A4%ED%8E%98%EC%9D%B8%EC%96%B4"
                    "ko" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95"
                    "en" -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%98%81%EC%96%B4"
                    else -> "https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95_%EC%98%81%EC%96%B4"
                }

                /** loadUrl : Loads the given URL. */
                webView.loadUrl(helpPage)

                //webView.loadUrl("https://likewind.cloud/doku.php?id=computer:programming:%EC%97%AC%ED%96%89%EA%B8%B0_%EC%95%B1_%EC%82%AC%EC%9A%A9%EB%B2%95")
                return true
            }

            4 -> {
                webView.reload()
                return true

            }


            else -> return super.onContextItemSelected(item)
        }
    }

    private fun onDownloadComplete()
    {
        /**  Code that receives and handles broadcast intents sent by Context.sendBroadcast(Intent) */
        val onComplete = object : BroadcastReceiver() {
            override fun onReceive(ctxt: Context, intent: Intent) {
                Toast.makeText(context,"File Downloaded",Toast.LENGTH_LONG).show()
            }
        }

        /** Register to receives above broadcast */
        registerReceiver(onComplete, IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE));
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun configureWebView()
    {
        //webView.webViewClient = MyWebViewClient()
        webView.webViewClient = object : WebViewClient() {

           override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
               val url = request?.url.toString()

               // Check if the URL starts with "mailto:"
               if (url.startsWith("mailto:")) {
                   // Handle mailto: links
                   val intent = Intent(Intent.ACTION_SENDTO, Uri.parse(url))
                   startActivity(intent)
                   return true
               }

               // Check if the URL starts with "tel:"
               if (url.startsWith("tel:")) {
                   // Handle tel: links
                   val intent = Intent(Intent.ACTION_DIAL, Uri.parse(url))
                   startActivity(intent)
                   return true
               }

               // Check if the URL starts with "sms:"
               if (url.startsWith("sms:")) {
                   // Handle sms: links
                   val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
                   startActivity(intent)
                   return true
               }

               // Load other URLs in the WebView
               view?.loadUrl(url)
               return true
           }

            override fun onReceivedError(
                view: WebView?,
                request: WebResourceRequest?,
                error: WebResourceError?
            ) {

    super.onReceivedError(view, request, error)

    // Extract error details
    val errorCode = error?.errorCode ?: -1
    //val description = error?.description ?: "Unknown Error"

    if (errorCode == -2 || errorCode == -8) {

        // Get the appropriate error message based on the device's language
        val errorMessage = when (Locale.getDefault().language) {
            "ko" -> getString(R.string.error_message_korean)
            "es" -> getString(R.string.error_message_spanish)
            else -> getString(R.string.error_message_english)
        }

        // Load the local image file aa.jpg centered on the screen
        val htmlContent = """
        <html>
            <head>
                <style>
                    body {
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        justify-content: center;
                        height: 100vh;
                        margin: 0;
                    }
                    img {
                        width: auto;
                        height: auto;
                    }
                </style>
            </head>
            <body>
                <img src='file:///android_res/drawable/error.jpg'>
                $errorMessage
            </body>
        </html>
    """

        // Display the custom content in WebView
        view?.loadDataWithBaseURL(null, htmlContent, "text/html", "utf-8", null)

    }
}
           override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
               // Page loading started, show the horizontal progress bar
               progressBar.visibility = View.VISIBLE
           }

           override fun onPageFinished(view: WebView?, url: String?) {
               progressBar.visibility = View.GONE
               super.onPageFinished(view, url)
               // This method will be called when the page is fully loaded

               /**
               // Stop the refreshing animation
               swipeRefreshLayout.isRefreshing = false
               */
           }
        }

        webView.webChromeClient = FullScreenableChromeClient(activity)  // Full screen on Google map

        /** getSettings() : Gets the WebSettings object used to control the settings for this WebView. */
        /** We will use it to enable the Java Script Support. */
        webView.settings.javaScriptEnabled = true
        webView.settings.builtInZoomControls = true
        webView.settings.setSupportZoom(true)
        webView.settings.displayZoomControls = false

        /**
        // Set up swipe-to-refresh
        swipeRefreshLayout.setOnRefreshListener {
            // Reload the WebView content
            webView.reload()
        }
*/
        
        /** loadUrl : Loads the given URL. */
        webView.loadUrl(downloadPage)

        /** File Download Listener */
        webView.setDownloadListener(downloadListener)
    }

    /**
     * Custom WebViewClient to override URL Loading.
     */

    private inner class MyWebViewClient : WebViewClient() {

        /**
         * Override to open URL in WebView
         * */
        override fun shouldOverrideUrlLoading(view: WebView, url: String): Boolean {
            view.loadUrl(url)
            return true
        }

        /**
         * Override to open URL in WebView
         * */
        @RequiresApi(Build.VERSION_CODES.LOLLIPOP)
        override fun shouldOverrideUrlLoading(view: WebView, request: WebResourceRequest): Boolean {
            view.loadUrl(request.url.toString())
            return true
        }
    }

    private fun createDownloadListener()
    {


        /** A New Download Listener for our WebView */
        downloadListener = DownloadListener { url, userAgent, contentDescription, mimetype, contentLength ->

            /**
             * This class contains all the information necessary to request a new download.
             * The URI is the only required parameter. Note that the default download destination
             * is a shared volume where the system might delete your file if it needs to reclaim
             * space for system use.
             * */
            val request = DownloadManager.Request(Uri.parse(url))

            /**
             * If the file to be downloaded is to be scanned by MediaScanner, this method should
             * be called before DownloadManager.enqueue(Request) is called.
             */
            request.allowScanningByMediaScanner()

            /**
             * Control whether a system notification is posted by the download manager while this
             * download is running or when it is completed.
             * */
            request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)

            /**
             * Guesses canonical filename that a download would have, using the
             * URL and contentDisposition.
             * */

            //Log.d("tag0", "msg"+url)
            //Log.d("tag1", "msg"+contentDescription)

            var str_arr = url.split(":")

            //Log.d("tag1-1", "msg"+str_arr.get(0))
            //Log.d("tag1-1", "msg"+str_arr.get(1))
            //Log.d("tag1-1", "msg"+str_arr.get(2))
            //Log.d("tag1-1", "msg"+str_arr.last())

            //val fileName = URLUtil.guessFileName(url, contentDescription, mimetype)

            val fileName = str_arr.last()   // modify code by wjkim

            //Log.d("tag2", "msg"+fileName)

            /**
             * Set the local destination for the downloaded file to a path within the public
             * external storage directory (as returned by Environment.getExternalStoragePublicDirectory(String)).
             * */
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName)

            /**
             * Get Download Manager Service
             * */
            val dManager = getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager

            /**
             * Enqueue a new request to Download our File.
             * */

            if(writeAccess)
                dManager.enqueue(request)
            else
            {
                Toast.makeText(context,"Unable to download file. Required Privileges are not available.",Toast.LENGTH_LONG).show()
                checkWriteAccess()
            }

        }
    }

    private fun checkWriteAccess()
    {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
        {
            /**
             * Check for permission status.
             * */
            if (checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)
            {
                if (shouldShowRequestPermissionRationale(Manifest.permission.WRITE_EXTERNAL_STORAGE))
                {
                    val builder = AlertDialog.Builder(activity)
                    builder.setMessage("Required permission to write external storage to save downloaded file.")
                    builder.setTitle("Please Grant Write Permission")
                    builder.setPositiveButton("OK") { _, _->
                        ActivityCompat.requestPermissions(
                            activity,
                            arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE),
                            PERMISSION_REQUEST_CODE
                        )
                    }
                    builder.setNeutralButton("Cancel", null)
                    val dialog = builder.create()
                    dialog.show()
                } else {
                    ActivityCompat.requestPermissions(
                        activity,
                        arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE),
                        PERMISSION_REQUEST_CODE
                    )
                }
            }
            else {
                /**
                 * Already have required permission.
                 * */
                // modify code
                writeAccess = true
            }
        }
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray) {
        when (requestCode) {
            PERMISSION_REQUEST_CODE -> {
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    writeAccess=true
                } else {
                    // Permission denied
                    writeAccess=false
                    Toast.makeText(context,"Permission Denied. This app will not work with right permission.",Toast.LENGTH_LONG).show()
                }
            }
        }
    }

    private fun getRandomQuote(): String {
        val quotes = arrayOf(
            "자신을 둘러싼 껍질을 깨고 나오면 닭이 되지만, 남이 껍질을 깨주면 계란 후라이가 된다",
            "그 누구도 인생이 끝날 때 '아, 사무실에서 더 열심히 일할 걸' 이라는 말을 하고 싶어 하지 않는다",
            "여유를 갖고 자신의 개성대로 사세요",
            "생각하며 살지 않으면, 사는대로 생각하게 된다",
            "꿈만 꾸지 말고, 종이에 적어라",
            "배는 항구에 있을 때 가장 안전하다. 하지만 배는 그럴려고 만들어진 것이 아니다"
        )

        val randomValue = Random.nextInt(quotes.size)
        return quotes[randomValue]
    }

    private fun calculateDaysDifference(startDate: Date, endDate: Date): Long {
        val differenceInMillis = endDate.time - startDate.time
        return TimeUnit.DAYS.convert(differenceInMillis, TimeUnit.MILLISECONDS)
    }

    private fun getDateFromString(dateString: String): Date {
        val dateFormat = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
        return dateFormat.parse(dateString) ?: Date()
    }

    private fun getNumKorString(value: Long): String {
        val kor1 = listOf("", "일", "이", "삼", "사","오","육","칠","팔","구")
        val kor2 = listOf("", "십", "백", "천")
        val kor3 = listOf("", "만", "억", "조", "경")
        val kor4 = listOf("일")

        val strVal = value.toString()
        val strLen = strVal.length
        var strRet = ""

        strVal.forEachIndexed { i, c ->
            val n = (c-48).toInt()

            val digit = strLen - i - 1
            if(n > 0) {
                strRet = "$strRet${kor1[n]}${kor2[digit%4]}"
            }

            if(digit % 4 == 0 && strRet.last() != ' '){
                strRet = "$strRet${kor3[digit/4]}"
            }

        }

        //strRet = "$strRet${kor4[0]}"

        return strRet
    }


}
