package com.likewind.myapplication

import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.view.WindowManager
import android.widget.ImageView
import androidx.appcompat.app.AppCompatActivity
import com.bumptech.glide.Glide
import jp.wasabeef.glide.transformations.gpu.SketchFilterTransformation
import kotlinx.android.synthetic.main.activity_start.*
import java.util.*

class StartActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_start)

        window.setFlags(
            WindowManager.LayoutParams.FLAG_FULLSCREEN,
            WindowManager.LayoutParams.FLAG_FULLSCREEN
        )

        val imageArray = arrayOf("sp1", "sp2", "sp3", "sp4", "sp5", "sp6", "sp7", "sp8", "sp9", "sp10", "sp11", "sp12", "sp13", "sp14", "sp15", "sp16", "sp17", "sp18")
        val randomIndex = Random().nextInt(imageArray.size)
        val randomImageName = imageArray[randomIndex]
        val resourceId = resources.getIdentifier(randomImageName, "drawable", packageName)
        imageView.setImageResource(resourceId)

        val imageView: ImageView = findViewById(R.id.imageView)
        val handler = Handler()

        // Fade in animation with Sketch effect applied
        val fadeInSketch = ObjectAnimator.ofFloat(imageView, "alpha", 0f, 1f)
        fadeInSketch.duration = 1000

        // Fade out animation with Sketch effect removed
        val fadeOut = ObjectAnimator.ofFloat(imageView, "alpha", 1f, 0f)
        fadeOut.duration = 1000

        // Combine fade in and fade out animations
        val animatorSet = AnimatorSet()

        // Load original image
        Glide.with(this)
            .load(resourceId)
            .into(imageView)

        // Apply Sketch effect and start fade in animation
        handler.postDelayed({
            Glide.with(this)
                .load(resourceId)
                .transform(SketchFilterTransformation())
                .into(imageView)
            animatorSet.play(fadeInSketch)
            animatorSet.start()
        }, 0)

        // Keep the Sketch effect applied for 1 second
        handler.postDelayed({
            // Do nothing, wait for 1 second
        }, 1000)

        // Remove Sketch effect
        handler.postDelayed({
            Glide.with(this)
                .load(resourceId)
                .into(imageView)
            animatorSet.play(fadeInSketch)
            animatorSet.start()
        }, 2000)

        // Keep the Sketch effect removed for 1 second
        handler.postDelayed({
            // Do nothing, wait for 1 second
        }, 3000)

        // Start fade out animation
        handler.postDelayed({
            animatorSet.play(fadeOut)
            animatorSet.start()
        }, 4000)


        // 일정 시간 지연 이후 실행하기 위한 코드
        Handler(Looper.getMainLooper()).postDelayed({

            /** Check permission to write in external storage */
            //checkWriteAccess()

            // 일정 시간이 지나면 MainActivity로 이동
            val intent = Intent(this, MainActivity::class.java)
            startActivity(intent)

            // 이전 키를 눌렀을 때 스플래스 스크린 화면으로 이동을 방지하기 위해
            // 이동한 다음 사용안함으로 finish 처리
            finish()

        }, 5000) // 시간 0.5초 이후 실행
    }
}

